# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Create a new publishing page
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# URL to the SharePoint site
$webUrl = "http://sharepoint/site"

# File name for page
$pageFileName = "PowerShellPage.aspx"

# Title for page
$title = "PowerShell Page"

# Page layout
$layoutName = "Blank Web Part Page"

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Get the SharePoint Site
$web = Get-SPWeb $webUrl
	
# Get the Publishing Site from the SharePoint Site
$pubWeb = [Microsoft.SharePoint.Publishing.PublishingWeb]::GetPublishingWeb($web)

# Get the specified Page Layout from the available layouts
$layout = $pubWeb.GetAvailablePageLayouts() | Where-Object { $_.Title -eq $layoutName }

# Create the new Page
$page = $pubWeb.AddPublishingPage($pageFileName, $layout)
$page.Update()

# Set the Title of the Page
$page.ListItem["Title"] = $title
$page.ListItem.Update()

# Dispose of the site object
$web.Dispose()

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 